/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.ResourceMutableTreeNode;
import java.beans.PropertyChangeEvent;
import java.util.Set;

public final class ResourceInventoryTreeNode
extends ResourceMutableTreeNode {
    private static final String TRACEMASK_T = "XBUIRINT";
    private static final String TRACEMASK_F = "XBUIRINF";
    private static final String TRACEMASK_D = "XBUIRIND";

    protected ResourceInventoryTreeNode(ResourceInventoryTreeNode clonee, BonsaiTreeNode parent) {
        this(clonee, parent, clonee.getXMLKey());
    }

    protected ResourceInventoryTreeNode(ResourceInventoryTreeNode clonee, BonsaiTreeNode parent, String idPostfix) {
        super(clonee, parent, idPostfix);
    }

    public ResourceInventoryTreeNode(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) {
        this(configBean, parent, defaultWorkarea, filters, configBean.getKey());
    }

    public ResourceInventoryTreeNode(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters, String idPostfix) {
        super(configBean, parent, defaultWorkarea, filters, idPostfix);
        this.setListener(new InventoryTreeNodeListener());
    }

    public BonsaiTreeNode getCopy(BonsaiTreeNode parent, boolean copyChildren) {
        ResourceInventoryTreeNode node = new ResourceInventoryTreeNode(this, parent);
        if (copyChildren) {
            node.copyChildren(this);
        }
        return node;
    }

    private class InventoryTreeNodeListener
    extends ResourceMutableTreeNode.AbstractTreeNodeListener {
        private InventoryTreeNodeListener() {
            super(ResourceInventoryTreeNode.this, ResourceInventoryTreeNode.this);
        }

        protected synchronized void register() {
            UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport().addInventoryListener(this);
        }

        protected synchronized void deregister() {
            UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport().removeInventoryListener(this);
        }

        public synchronized void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            Trace.trace(ResourceInventoryTreeNode.TRACEMASK_F, "--> ResourceInventoryTreeNode.propertyChange(" + propertyName + ") [node='" + this.getOwner().getId() + "']");
            try {
                BonsaiTreeManager.getBonsaiTreeManager().rebuildBranch(this.getOwner());
            }
            catch (InvalidIdException invalidIdException) {
                // empty catch block
            }
            Trace.trace(ResourceInventoryTreeNode.TRACEMASK_F, "<-- ResourceRootTreeNode.propertyChange()");
        }
    }
}

